﻿//Name: William Miranda-Hill
//Class: CPMS 378       
//Assignment #: 7, Shape Polymorphism
//Due Date: 11/21/17
//Problem: The program will display a form that accepts input for the side/radius of a sphere, cube, or tetrahedron. It will output via 3 classes with inheritence polymorphically their relevent measurements. 
//
//Input: Accept input for one of three 3D shapes via an input textbox for side/raidus and a combobox for shape selection.
//Calculation: Via 3 inherited classes the surface area, volume, and side/radius of the shapes will be calculated polymorphically.
//Output: All measurements will be outputted to the correct output label in the form.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ShapePolymorphism
{
    public partial class Form1 : Form
    {
        //Declare objects of shapes from inherited classes
        ShapeSphere sphere;
        ShapeCube cube;
        ShapeTetrahedron tetrahedron;

        public Form1()
        {
            InitializeComponent();

            //Initialize shapes
            sphere = new ShapeSphere();
            cube = new ShapeCube();
            tetrahedron = new ShapeTetrahedron();
        }   //End form1

        public void Update(Shape[] arrayOfShapes)
        {
            //Polymorhically obtain info and place in correct output text box 
            foreach (Shape shape in arrayOfShapes)
            {
                string output = shape.Name + ": " + shape + "\r\nSide or Radius = " + shape.Side().ToString("F") + "\r\nArea = " + shape.Area().ToString("F") + "\r\nVolume = " + shape.Volume().ToString("F");
                if (shape.Name == "Cube" && (shapeComboBox.SelectedIndex == 0)) cubeOutputLabel.Text = output;
                if (shape.Name == "Sphere" && (shapeComboBox.SelectedIndex == 1)) sphereOutputLabel.Text = output;
                if (shape.Name == "Tetrahedron" && (shapeComboBox.SelectedIndex == 2)) tetrahedronOutputLabel.Text = output;
            }   //End foreach
        }   //End method
        private void setButton_Click(object sender, EventArgs e)
        {
            //Create array 
            Shape[] arrayOfShapes = new Shape[3];

            //Initialize array 
            arrayOfShapes[0] = sphere;
            arrayOfShapes[1] = cube;
            arrayOfShapes[2] = tetrahedron;

            //1. Decide what input to accept based on combobox selection
            //2. Validate the input in the textbox with a try/catch
            //3. Pass shapes to update method (only if input validated)
            switch (shapeComboBox.SelectedIndex)
            {
                case 0:
                    //Apply input to cube
                    try
                    {
                        do
                        {
                            cube.Length = Int32.Parse(inputTextBox.Text);

                            //inputTextBox.Text = "";
                        } while (cube.Length < 0);
                        //Polymorhically obtain info and place in correct output text box with method
                        Update(arrayOfShapes);
                    }
                    catch (FormatException)
                    {
                        MessageBox.Show("Length must be positive number", "Invalid number format",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }   //End try/catch
                    break;
                case 1:
                    //Apply input to sphere
                    try
                    {
                        do  // accept only positive
                        {
                            sphere.Radius = Int32.Parse(inputTextBox.Text);

                            //inputTextBox.Text = "";
                        } while (sphere.Radius < 0);
                        //Polymorhically obtain info and place in correct output text box with method
                        Update(arrayOfShapes);
                    }
                    catch (FormatException)
                    {
                        MessageBox.Show("Radius must be positive number", "Invalid number format",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }   //End try/catch
                    break;
                case 2:
                    //Apply input to tetrahedron    
                    try
                    {
                        do  // accept only positive
                        {
                            tetrahedron.Length = Int32.Parse(inputTextBox.Text);

                            inputTextBox.Text = "";
                        } while (tetrahedron.Length < 0);
                        //Polymorhically obtain info and place in correct output text box with method
                        Update(arrayOfShapes);
                    }
                    catch (FormatException)
                    {
                        MessageBox.Show("Side must be positive number", "Invalid number format",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }   //End try/catch
                    break;
                default:
                    break;
            }   //End switch/case
        }   //End event

        private void resetButton_Click(object sender, EventArgs e)
        {
            //clear all output text boxes
            sphereOutputLabel.Text = "";
            cubeOutputLabel.Text = "";
            tetrahedronOutputLabel.Text = "";
            //clear the input textbox 
            inputTextBox.Text = "";
            shapeComboBox.SelectedIndex = 0;
        }   //End event
    }   //End class
}   //End namespace
